%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MATLAB code: Exercise 6.6, first part
% File: exercise_6-6.m (contains first and second part)
%
% MC and BS results for the moment estimator and the LS estimator.
% 
% BL model: Y_{t} = beta * eps_{t-1} * Y_{t-2} + eps_{t}, 
%           with eps_{t} ~ N(0,1) distributed.
%
% MM =  Method of moments estimator,
%          2mean(Y)/[(g0-g1) + (g0^{2}-6g0g1-3*g1^2)^{1/2}]
% LS = Least squares estimator
% BS = Bootstrap estimator
%
% totestm = [LS, MM, Bootst MM, Bootstr LS; 
%   std.LS (no BS),std. MM (no BS),std. Bootst MM,std. Bootstr LS]       
% table   = Results for MM and LS estimators, as shown in Table  
%           6.2 of the Solutions Manual.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
s = RandStream('mcg16807','Seed',0);  % Set the seed
RandStream.setGlobalStream(s)      

x(1)  = 0;
y     = zeros(1000);
nboot = 1000;
sumMM = 0;
nrep  = 1000;
n     = 1100;
b     = 0.4;

% True percentage points of Normal distribution
p = [0.01 0.025 0.05 0.1 0.203 0.305 0.4 0.5 ...
     0.6 0.695 0.797 0.9 0.95 0.975 0.99];
z = norminv(p,0,1);

t = [-2.2 -2 -1.8 -1.6 -1.4 -1.2 -1 -0.8 -0.6 -0.4 -0.2 0 ...
      0.2 0.4 0.6 0.8 1 1.2 1.4 1.6 1.8 2 2.2];

%%%%%%%%% MM estimator    %%%%%%%%%%%%%
for jrep = 1:nrep      % Start replications
    r = normrnd(0,1,1,n+1);
    for i = 2:n        % Generation of X's
        x(i) = b*x(i-1)*r(i-1)+r(i);
    end
    y    = x(101:n);   % 100 observations for warming-up
    ny   = length(y);
    avgy = mean(y);    % Calculation of moments
    vary = var(y)*(ny-1)/ny;

    sum = 0;
    for i = 1:ny-1
        sum = sum+(y(i)-avgy)*(y(i+1)-avgy);  % Lag 1 sample ACVF
    end
    covy = sum/ny;
    
    ry = covy/vary;
    if (ry < 0.1547)
       sumMM = sumMM+1;
    bhead = (2*avgy)/((vary-covy)+sqrt(vary^2-6*vary*covy-3*covy^2)); 
       bMM(sumMM) = bhead;   % The MM estimate
    end

%%%%%%%%%%%%  LS %%%%%%%%%%%%%%%%%%%%
%  Initialization
   nnLS = 0;
   n1   = ny-1;
   bLS  = b;
   b0   = 0;
%
%  Calculation of LS estimate

   dbc = b0-bLS;
   for uu = 1:100
     if abs(dbc)> 0.00001
       b0 = bLS;
       nnLS = nnLS+1;

%%     Generation of e's    
       e(1) = y(1);
       for j = 2:ny
           e(j) = y(j)-b0*y(j-1)*e(j-1);
       end
%%     Generation of w's 
       w(1) = 0;
       for j = 2:ny
           w(j) = e(j-1)*y(j-1)-b0*w(j-1)*y(j-1);
       end
%%     Computation of delta bLS
       suma = 0;
       sumb = 0;
       for i = 1:ny
          suma = suma+e(i)*w(i);
          sumb = sumb+w(i)^2;
       end
       dbc = suma/sumb;
%%     The improved LS estimate 
       bLS = b0+dbc;
     end  
   end  % end uu=1:100
      bestLS(jrep) = bLS;     
end     % end replications j=1:nrep  NO BOOTSTRAPPING

betaMM    = mean(bMM);           % Overall mean MM estimator
StdbetaMM = sqrt(var(bMM));      % Overall standard dev
betaLS    = mean(bestLS);   
StdbetaLS = sqrt(var(bestLS));   % Overall std dev LS

%%%%%%%%%%%%%%%%%%%%  Bootstrapping  MM estimator %%%%%%%%%%%%%%%
res(1)   = y(1);
resLS(1) = y(1);
for j = 2:ny
    res(j)   = y(j)-betaMM*y(j-1)*res(j-1);
    resLS(j) = y(j)-betaLS*y(j-1)*resLS(j-1);    
end
ares   = mean(res);
aresLS = mean(resLS);

for i = 1:ny
    ecen(i)   = res(i)-ares;
    ecenLS(i) = resLS(i)-aresLS;
end
id = ceil(rand(ny,nboot)*ny); % Generate a matrix of integers 
                              % that range from 1 to ny to use
                         % as indices into the centered residuals
                                
bstres   = ecen(id);          % Use this index to 'sample' from the 
                              % centered residuals
bstresLS = ecenLS(id);          

xst   = zeros(ny,nboot); 
xstLS = zeros(ny,nboot); 

for j = 1:nboot
    xst(1,j)   = bstres(1,j);
    xstLS(1,j) = bstresLS(1,j);
    for i = 2:ny
        xst(i,j)   = bstres(i,j)+betaMM*xst(i-1,j)*bstres(i-1,j);
  xstLS(i,j) = bstresLS(i,j)+betaLS*xstLS(i-1,j)*bstresLS(i-1,j);        
    end
end

axst = mean(xst);
vxst = var(xst)*(ny-1)/ny;

for j = 1:nboot
    xx      = (xst(:,j)-axst(j));
    xx0     = xx(1:ny-1);
    xx1     = xx(2:ny);
    cxst(j) = xx0'*xx1/ny;
    rxst(j) = cxst(j)/vxst(j);   % Lag 1 autocorrelation 
end

nb = 0;
for j = 1:nboot
    if rxst(j) < 0.1547   % MM method fails if rxst > 0.1547 
                          % (no real solution)
       nb = nb+1;         % Bootstrap sample size
     bhst(j) = 2*axst(j)/((vxst(j)-cxst(j))+sqrt(vxst(j)^2 ...
               -6*vxst(j)*cxst(j)-3*cxst(j)^2));
    end
end

% Computation of BS sample mean and variance of the MM estimator
betaBSMM = mean(bhst);
StdBSMM  = sqrt(var(bhst)*(nb-1)/nb);

%%%%%%%%%%%%%%%%%  Bootstrapping LS estimator %%%%%%%%%%%%%%%
%% Computation of BS LS estimate
 
for jj = 1:nboot
%  Initialization   
   nn   = 0;
   n1   = ny-1;
   bBLS = b+0.1;
   b0B  = 0;

%  Calculation of LS estimate
   for uu = 1:100
    if abs(b0B-bBLS)> 0.00001
      b0B = bBLS;
      nn  = nn+1;
%%    Generation of e's    
      e(1,jj) = xstLS(1,jj);
      for j = 2:ny
         e(j,jj) = xstLS(j,jj)-b0B*xstLS(j-1,jj)*e(j-1,jj);          
      end
%%    Generation of w's 
      w(1,jj) = 0;
      for j = 2:ny
       w(j,jj) = e(j-1,jj)*xstLS(j-1,jj)-b0B*w(j-1,jj)*xstLS(j-1,jj); 
      end
%%    Computation of delta bLS
      suma = 0;
      sumb = 0;
      for i = 1:ny
         suma = suma+e(i,jj)*w(i,jj);
         sumb = sumb+w(i,jj)^2;
      end
      dbc = suma/sumb;
%%    The improved LS estimate 
      bBLS = b0B+dbc;
    end
  end    % end of loop uu=1:1000     
bestBBLS(jj) = bBLS;
end      % end of loop jj=1:nboot

% Computation of BS LS estimate sample mean and std. dev.
betaBSLS = mean(bestBBLS);
StdBSLS  = sqrt(var(bestBBLS)*(nb-1)/nb);

%%%%%%%%%%%% Bootstrap MM percentages %%%%%%%%%%%
   nc = zeros(15,1);
   nh = zeros(23,1);

   for k = 1:nboot                       % betaMM = No BS
       zb(k) = (bhst(k)-betaMM)/StdBSMM; % bhst   = BS results
       for i = 1:15
           if zb(k) <= z(i)
              nc(i) = nc(i)+1;
           end
       end
       for j = 1:23
          if zb(k) <= t(j)
            nh(j) = nh(j)+1;
          end
       end
   end  
   for i = 1:15
       bcdfMM(i) = nc(i)/1000;   % Approximate CDF
   end
   for j = 1:23
       bfrqMM(j) = nh(j)/1000;   % Relative frequency
   end
   
%%%%%%%%%%%% Bootstrap LS percentages %%%%%%%%%%%
   nc = zeros(15,1);
   nh = zeros(23,1);
   
   for k = 1:nboot                           % betaMM = No BS
zb(k) = (bestBBLS(k)-betaLS)/StdBSLS; % bhstLS = BS results LS
       for i = 1:15
           if zb(k) <= z(i)
              nc(i) = nc(i)+1;
           end
       end
       for j = 1:23
          if zb(k) <= t(j)
            nh(j)  = nh(j)+1;
          end
       end
   end  
   for i = 1:15
       bcdfLS(i) = nc(i)/1000;   % Approximate CDF
   end
   for j = 1:23
       bfrqLS(j) = nh(j)/1000;   % Relative frequency
   end   
 
table = [betaMM,betaBSMM,StdBSMM,betaLS,betaBSLS,StdBSLS];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MATLAB code: Exercise 6.6, second part
% File: exercise_6-6.m (contains first and second part)
%
% Computation of asymptotic standard deviation (sdMM) of the 
% MM estimator tau^{*} based on Kim et al. (1990).
%
% Reference:
% Kim, W.K., Billard, L., and Basawa, I.V. (1990).
%   Estimation for the first-order diagonal BL time series model.
%   Journal of Time Series Analysis, 11(3), 215-229.
%   DOI: 10.1111/j.1467-9892.1990.tb00053.x. 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
n    = 1000;   % sample size
se   = 1;
tau  = 0.4;    % parameter
lam  = tau*se;
s11  = (se^2)*(1+3*lam^2-lam^4)/(1-lam^2);
s12  = 4*(se^3)*lam*(1+4*lam^2+lam^4)/(1-lam^2);
s13  = 2*(se^3)*lam*(2+7*lam^2+3*lam^4+6*lam^6)/(1-lam^2);
s22  = 2*(se^4)*(1+15*lam^2+18*lam^4+44*lam^6+42*lam^8- ...
       102*lam^(10))/(((1-lam^2)^3)*(1-3*lam^4));
s23  = (se^4)*(lam^2)*(30+106*lam^2+239*lam^4+159*lam^6- ...
       132*lam^8)/(1-lam^2)^2;
s33  = (se^4)*(1+23*lam^2+80*lam^4+76*lam^6-84*lam^8- ... 
       120*lam^(10)-216*lam^(12))/((1-lam^2)*(1-3*lam^4));
SS   = [s11 s12 s13; s12 s22 s23; s13 s23 s33];

b1   = se^(-2);
b2   = -tau*(2*se^2)^(-1)*(1+(1-2*lam^2+4*lam^4)* ...
        (1-4*lam^2+8*lam^6+4*lam^8)^(-1/2));
b3   =  tau*(2*se^2)^(-1)*(1+3*(1+2*lam^2)* ... 
        (1-4*lam^2+8*lam^6+4*lam^8)^(-1/2));
beta = [b1 b2 b3];

sdMM = sqrt(beta * SS * beta'/n);
